/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.PlayerVolumesScreen;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5253;

public class PlayerVolumeEntry
extends ListScreenEntryBase<PlayerVolumeEntry> {
    protected static final class_2588 OTHER_VOLUME = new class_2588("message.voicechat.other_volume");
    protected static final class_2588 OTHER_VOLUME_DESCRIPTION = new class_2588("message.voicechat.other_volume.description");
    protected static final class_2960 OTHER_VOLUME_ICON = new class_2960("voicechat", "textures/icons/other_volume.png");
    protected static final int SKIN_SIZE = 24;
    protected static final int PADDING = 4;
    protected static final int BG_FILL = class_5253.class_5254.method_27764((int)255, (int)74, (int)74, (int)74);
    protected static final int PLAYER_NAME_COLOR = class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255);
    protected final class_310 minecraft = class_310.method_1551();
    @Nullable
    protected final PlayerState state;
    protected final PlayerVolumesScreen screen;
    protected final AdjustVolumeSlider volumeSlider;

    public PlayerVolumeEntry(@Nullable PlayerState state, PlayerVolumesScreen screen) {
        this.state = state;
        this.screen = screen;
        this.volumeSlider = new AdjustVolumeSlider(0, 0, 100, 20, state != null ? state.getUuid() : class_156.field_25140);
        this.children.add(this.volumeSlider);
    }

    public void method_25343(class_4587 poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        int skinX = left + 4;
        int skinY = top + (height - 24) / 2;
        int textX = skinX + 24 + 4;
        Objects.requireNonNull(this.minecraft.field_1772);
        int textY = top + (height - 9) / 2;
        class_332.method_25294((class_4587)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL);
        if (this.state != null) {
            RenderSystem.setShaderTexture((int)0, (class_2960)GameProfileUtils.getSkin(this.state.getUuid()));
            class_332.method_25293((class_4587)poseStack, (int)skinX, (int)skinY, (int)24, (int)24, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.enableBlend();
            class_332.method_25293((class_4587)poseStack, (int)skinX, (int)skinY, (int)24, (int)24, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.disableBlend();
            this.minecraft.field_1772.method_1729(poseStack, this.state.getName(), (float)textX, (float)textY, PLAYER_NAME_COLOR);
        } else {
            RenderSystem.setShaderTexture((int)0, (class_2960)OTHER_VOLUME_ICON);
            class_332.method_25293((class_4587)poseStack, (int)skinX, (int)skinY, (int)24, (int)24, (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
            this.minecraft.field_1772.method_30883(poseStack, (class_2561)OTHER_VOLUME, (float)textX, (float)textY, PLAYER_NAME_COLOR);
            if (hovered) {
                this.screen.postRender(() -> this.screen.method_25417(poseStack, Collections.singletonList(OTHER_VOLUME_DESCRIPTION.method_30937()), mouseX, mouseY));
            }
        }
        this.volumeSlider.field_22760 = left + (width - this.volumeSlider.method_25368() - 4);
        this.volumeSlider.field_22761 = top + (height - this.volumeSlider.method_25364()) / 2;
        this.volumeSlider.method_25394(poseStack, mouseX, mouseY, delta);
    }

    @Nullable
    public PlayerState getState() {
        return this.state;
    }
}

