/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl.audiochannel;

import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.ServerLevel;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import de.maxhenkel.voicechat.api.packets.MicrophonePacket;
import de.maxhenkel.voicechat.plugins.impl.PositionImpl;
import de.maxhenkel.voicechat.plugins.impl.ServerPlayerImpl;
import de.maxhenkel.voicechat.plugins.impl.audiochannel.AudioChannelImpl;
import de.maxhenkel.voicechat.voice.common.LocationSoundPacket;
import de.maxhenkel.voicechat.voice.server.Server;
import de.maxhenkel.voicechat.voice.server.ServerWorldUtils;
import java.util.UUID;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class LocationalAudioChannelImpl
extends AudioChannelImpl
implements LocationalAudioChannel {
    protected ServerLevel level;
    protected PositionImpl position;

    public LocationalAudioChannelImpl(UUID channelId, Server server, ServerLevel level, PositionImpl position) {
        super(channelId, server);
        this.level = level;
        this.position = position;
    }

    @Override
    public void updateLocation(Position position) {
        PositionImpl p;
        if (!(position instanceof PositionImpl)) {
            throw new IllegalArgumentException("position is not an instance of PositionImpl");
        }
        this.position = p = (PositionImpl)position;
    }

    @Override
    public Position getLocation() {
        return this.position;
    }

    @Override
    public void send(byte[] opusData) {
        this.broadcast(new LocationSoundPacket(this.channelId, this.position.getPosition(), opusData, this.sequenceNumber.getAndIncrement()));
    }

    @Override
    public void send(MicrophonePacket packet) {
        this.send(packet.getOpusEncodedData());
    }

    @Override
    public void flush() {
        this.broadcast(new LocationSoundPacket(this.channelId, this.position.getPosition(), new byte[0], this.sequenceNumber.getAndIncrement()));
    }

    private void broadcast(LocationSoundPacket packet) {
        this.server.broadcast(ServerWorldUtils.getPlayersInRange((class_3218)this.level.getServerLevel(), this.position.getPosition(), this.server.getBroadcastRange(), this.filter == null ? player -> true : player -> this.filter.test(new ServerPlayerImpl((class_3222)player))), packet, null, null, null, "plugin");
    }
}

