/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.authlib.GameProfile;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_746;
import org.apache.commons.io.FileUtils;

public class AudioRecorder {
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
    private final long timestamp;
    private final Path location;
    private final GameProfile ownProfile;
    private final Map<UUID, AudioChunk> chunks;
    private final AudioFormat stereoFormat;
    private final ExecutorService threadPool;

    public AudioRecorder(Path location, long timestamp) {
        this.timestamp = timestamp;
        this.location = location;
        location.toFile().mkdirs();
        this.chunks = new ConcurrentHashMap<UUID, AudioChunk>();
        this.ownProfile = class_310.method_1551().method_1548().method_1677();
        this.stereoFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 48000.0f, 16, 2, 4, 48000.0f, false);
        this.threadPool = Executors.newSingleThreadExecutor();
    }

    public static AudioRecorder create() {
        long timestamp = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp);
        String recordingDestination = VoicechatClient.CLIENT_CONFIG.recordingDestination.get();
        Path location = recordingDestination.trim().isEmpty() ? CommonCompatibilityManager.INSTANCE.getGameDirectory().resolve("voicechat_recordings").resolve(FORMAT.format(cal.getTime())) : Paths.get(recordingDestination, new String[0]).resolve(FORMAT.format(cal.getTime()));
        return new AudioRecorder(location, timestamp);
    }

    public Path getLocation() {
        return this.location;
    }

    public long getStartTime() {
        return this.timestamp;
    }

    public int getRecordedPlayerCount() {
        return this.chunks.size();
    }

    public String getDuration() {
        return this.getDuration(System.currentTimeMillis());
    }

    public String getDuration(long currentTime) {
        long duration = currentTime - this.timestamp;
        SimpleDateFormat fmt = new SimpleDateFormat(":mm:ss");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return duration / 3600000L + fmt.format(new Date(duration));
    }

    public String getStorage() {
        return this.getStorage(System.currentTimeMillis());
    }

    public String getStorage(long currentTime) {
        return FileUtils.byteCountToDisplaySize((long)((currentTime - this.timestamp) * (long)this.stereoFormat.getFrameSize() * ((long)this.stereoFormat.getFrameRate() / 1000L) * (long)this.getRecordedPlayerCount()));
    }

    private String lookupName(UUID uuid) {
        if (uuid.equals(this.ownProfile.getId())) {
            return this.ownProfile.getName();
        }
        String username = VoicechatClient.USERNAME_CACHE.getUsername(uuid);
        if (username == null) {
            return "system-" + uuid;
        }
        return username;
    }

    private Path getFilePath(UUID playerUUID, long timestamp) {
        return this.location.resolve(playerUUID.toString()).resolve(timestamp + ".wav");
    }

    public void appendChunk(UUID uuid, long timestamp, short[] data) throws IOException {
        long threshold;
        if (data.length <= 0) {
            this.flushChunkThreaded(uuid);
            return;
        }
        AudioChunk chunk = this.getChunk(uuid, timestamp);
        long passedTime = timestamp - chunk.getEndTimestamp();
        if (passedTime < (threshold = (long)VoicechatClient.CLIENT_CONFIG.outputBufferSize.get().intValue() * 20L)) {
            chunk.add(data, timestamp);
        } else {
            this.flushChunkThreaded(uuid);
            chunk = this.getChunk(uuid, timestamp);
            chunk.add(data, timestamp);
        }
    }

    private void writeChunk(UUID playerUUID, AudioChunk chunk) throws IOException {
        File file = this.getFilePath(playerUUID, chunk.getTimestamp()).toFile();
        file.getParentFile().mkdirs();
        byte[] data = chunk.getBytes();
        AudioRecorder.writeWav(data, this.stereoFormat, file);
    }

    private static void writeWav(byte[] data, AudioFormat format, File file) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        AudioSystem.write(new AudioInputStream(stream, format, data.length / format.getFrameSize()), AudioFileFormat.Type.WAVE, file);
    }

    public void flushChunkThreaded(UUID playerUUID) {
        AudioChunk chunk = this.getAndRemoveChunk(playerUUID);
        if (chunk == null) {
            return;
        }
        this.threadPool.execute(() -> {
            try {
                this.writeChunk(playerUUID, chunk);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    @Nullable
    private AudioChunk getAndRemoveChunk(UUID playerUUID) {
        return this.chunks.remove(playerUUID);
    }

    private AudioChunk getChunk(UUID uuid, long timestamp) {
        if (!this.chunks.containsKey(uuid)) {
            AudioChunk chunk = new AudioChunk(timestamp);
            this.chunks.put(uuid, chunk);
            return chunk;
        }
        return this.chunks.get(uuid);
    }

    public void flush() throws IOException {
        for (Map.Entry<UUID, AudioChunk> chunk : this.chunks.entrySet()) {
            this.writeChunk(chunk.getKey(), chunk.getValue());
        }
    }

    public void close() {
        if (this.threadPool.isShutdown()) {
            throw new IllegalStateException("Recorder already closed");
        }
        this.threadPool.shutdown();
    }

    public void saveAndClose() {
        this.save();
        this.close();
    }

    private void save() {
        this.threadPool.execute(() -> {
            this.send((class_2561)new class_2588("message.voicechat.processing_recording_session"));
            try {
                AtomicLong time = new AtomicLong();
                this.convert(progress -> {
                    if (progress.floatValue() >= 1.0f || System.currentTimeMillis() - time.get() > 1000L) {
                        this.send((class_2561)new class_2588("message.voicechat.processing_progress", new Object[]{new class_2585(String.valueOf((int)(progress.floatValue() * 100.0f))).method_27692(class_124.field_1080)}));
                        time.set(System.currentTimeMillis());
                    }
                });
                this.send((class_2561)new class_2588("message.voicechat.save_session", new Object[]{new class_2585(this.location.normalize().toString()).method_27692(class_124.field_1080).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2588("message.voicechat.open_folder"))).method_10958(new class_2558(class_2558.class_2559.field_11746, this.location.normalize().toString())))}));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.send((class_2561)new class_2588("message.voicechat.save_session_failed", new Object[]{e.getMessage()}));
            }
        });
    }

    private void send(class_2561 msg) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player != null && mc.field_1687 != null) {
            player.method_9203(msg, class_156.field_25140);
        } else {
            Voicechat.LOGGER.info(msg.getString());
        }
    }

    public void convert(Consumer<Float> progress) throws UnsupportedAudioFileException, IOException {
        this.flush();
        String[] directories = this.location.toFile().list();
        if (directories == null) {
            return;
        }
        for (int i = 0; i < directories.length; ++i) {
            UUID uuid;
            String directory = directories[i];
            float progressPerc = (float)i / (float)directories.length;
            try {
                uuid = UUID.fromString(directory);
            }
            catch (Exception e) {
                return;
            }
            File userDir = this.location.resolve(directory).toFile();
            File[] files = userDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".wav"));
            RandomAccessAudio audio = this.convertFiles(files, p -> progress.accept(Float.valueOf(progressPerc + p.floatValue() * (1.0f / (float)directories.length))));
            if (audio == null) {
                return;
            }
            AudioRecorder.writeWav(Utils.shortsToBytes(audio.getShorts()), audio.getAudioFormat(), this.location.resolve(this.lookupName(uuid) + ".wav").toFile());
            FileUtils.deleteDirectory((File)userDir);
        }
    }

    @Nullable
    private RandomAccessAudio convertFiles(File[] files, Consumer<Float> progress) throws UnsupportedAudioFileException, IOException {
        List audioSnippets = Arrays.stream(files).map(file -> {
            String[] split = file.getName().split("\\.");
            if (split.length != 2) {
                return null;
            }
            try {
                long num = Long.parseLong(split[0]);
                return new class_3545(file, (Object)num);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        RandomAccessAudio audio = null;
        for (int i = 0; i < audioSnippets.size(); ++i) {
            class_3545 snippet = (class_3545)audioSnippets.get(i);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream((File)snippet.method_15442());
            if (audio == null) {
                audio = new RandomAccessAudio(audioInputStream.getFormat());
            } else if (!audioInputStream.getFormat().matches(audio.getAudioFormat())) {
                Voicechat.LOGGER.warn("Audio snippet {} has the wrong audio format.", (Object)((File)snippet.method_15442()).getName());
                continue;
            }
            int ts = (int)((Long)snippet.method_15441() - this.timestamp);
            audio.insertAt(Utils.bytesToShorts(audioInputStream.readAllBytes()), ts);
            audioInputStream.close();
            progress.accept(Float.valueOf(((float)i + 1.0f) / (float)audioSnippets.size()));
        }
        return audio;
    }

    private class AudioChunk {
        private final long timestamp;
        private final ByteArrayOutputStream buffer;
        private long lastTimestamp;

        public AudioChunk(long timestamp) {
            this.timestamp = timestamp;
            this.buffer = new ByteArrayOutputStream();
        }

        public void add(short[] data, long timestamp) throws IOException {
            this.buffer.write(Utils.shortsToBytes(data));
            this.lastTimestamp = timestamp + (long)data.length * 1000L / (long)AudioRecorder.this.stereoFormat.getChannels() / (long)AudioRecorder.this.stereoFormat.getSampleRate();
        }

        public byte[] getBytes() {
            return this.buffer.toByteArray();
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getEndTimestamp() {
            return this.lastTimestamp;
        }
    }

    private static class RandomAccessAudio {
        private final AudioFormat audioFormat;
        private final DynamicShortArray data;

        public RandomAccessAudio(AudioFormat audioFormat) {
            this.audioFormat = audioFormat;
            this.data = new DynamicShortArray();
        }

        public void insertAt(short[] shorts, int offsetMilliseconds) throws UnsupportedAudioFileException {
            if (this.audioFormat.getFrameSize() == -1) {
                throw new UnsupportedAudioFileException("Frame size not specified");
            }
            if (this.audioFormat.getChannels() == -1) {
                throw new UnsupportedAudioFileException("Channel count not specified");
            }
            if (this.audioFormat.getSampleRate() == -1.0f) {
                throw new UnsupportedAudioFileException("Sample rate not specified");
            }
            int shortsPerMs = (int)this.audioFormat.getSampleRate() / 1000;
            this.data.add(shorts, offsetMilliseconds * shortsPerMs * this.audioFormat.getChannels());
        }

        public AudioFormat getAudioFormat() {
            return this.audioFormat;
        }

        public short[] getShorts() {
            return this.data.getShorts();
        }
    }

    private static class DynamicShortArray {
        private short[] data;

        public DynamicShortArray() {
            this(0);
        }

        public DynamicShortArray(int initialLength) {
            this.data = new short[initialLength];
        }

        public DynamicShortArray(short[] initialData) {
            this.data = initialData;
        }

        public void add(short[] shorts, int offset) {
            int max = shorts.length + offset;
            if (max > this.data.length) {
                short[] newData = new short[max];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
            System.arraycopy(shorts, 0, this.data, offset, shorts.length);
        }

        public short[] getShorts() {
            return this.data;
        }
    }
}

