/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.sun.jna.Platform;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.intercompatibility.ClientCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.macos.PermissionCheck;
import de.maxhenkel.voicechat.macos.jna.avfoundation.AVAuthorizationStatus;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.RequestSecretPacket;
import de.maxhenkel.voicechat.net.SecretPacket;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.ClientVoicechatConnection;
import de.maxhenkel.voicechat.voice.client.InitializationData;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import de.maxhenkel.voicechat.voice.client.PTTKeyHandler;
import de.maxhenkel.voicechat.voice.client.RenderEvents;
import de.maxhenkel.voicechat.voice.server.Server;
import io.netty.channel.local.LocalAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_746;

public class ClientManager {
    @Nullable
    private ClientVoicechat client;
    private final ClientPlayerStateManager playerStateManager = new ClientPlayerStateManager();
    private final PTTKeyHandler pttKeyHandler = new PTTKeyHandler();
    private final RenderEvents renderEvents = new RenderEvents();
    private final KeyEvents keyEvents = new KeyEvents();
    private final class_310 minecraft = class_310.method_1551();
    private static ClientManager instance;

    private ClientManager() {
        ClientCompatibilityManager.INSTANCE.onJoinWorld(this::onJoinWorld);
        ClientCompatibilityManager.INSTANCE.onDisconnect(this::onDisconnect);
        ClientCompatibilityManager.INSTANCE.onPublishServer(this::onPublishServer);
        ClientCompatibilityManager.INSTANCE.onVoiceChatConnected(connection -> {
            if (this.client != null) {
                this.client.onVoiceChatConnected((ClientVoicechatConnection)connection);
            }
        });
        ClientCompatibilityManager.INSTANCE.onVoiceChatDisconnected(() -> {
            if (this.client != null) {
                this.client.onVoiceChatDisconnected();
            }
        });
        CommonCompatibilityManager.INSTANCE.getNetManager().secretChannel.setClientListener((client, handler, packet) -> this.authenticate((SecretPacket)packet));
    }

    private void authenticate(SecretPacket secretPacket) {
        class_634 connection;
        if (this.client == null) {
            Voicechat.LOGGER.error("Received secret without a client being present");
            return;
        }
        Voicechat.LOGGER.info("Received secret");
        if (this.client.getConnection() != null) {
            ClientCompatibilityManager.INSTANCE.emitVoiceChatDisconnectedEvent();
        }
        if ((connection = this.minecraft.method_1562()) != null) {
            try {
                SocketAddress socketAddress = ClientCompatibilityManager.INSTANCE.getSocketAddress(connection.method_2872());
                if (socketAddress instanceof InetSocketAddress) {
                    InetSocketAddress address = (InetSocketAddress)socketAddress;
                    this.client.connect(new InitializationData(address.getHostString(), secretPacket));
                } else if (socketAddress instanceof LocalAddress) {
                    this.client.connect(new InitializationData("127.0.0.1", secretPacket));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void onJoinWorld() {
        if (this.client != null) {
            Voicechat.LOGGER.info("Disconnecting from previous connection due to server change");
            this.onDisconnect();
        }
        Voicechat.LOGGER.info("Sending secret request to the server");
        NetManager.sendToServer(new RequestSecretPacket(Voicechat.COMPATIBILITY_VERSION));
        this.client = new ClientVoicechat();
        this.checkMicrophonePermissions();
    }

    public static void sendPlayerError(String translationKey, @Nullable Exception e) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        player.method_9203((class_2561)class_2564.method_10885((class_2561)new class_2585(CommonCompatibilityManager.INSTANCE.getModName())).method_27692(class_124.field_1060).method_27693(" ").method_10852((class_2561)new class_2588(translationKey).method_27692(class_124.field_1061)).method_27694(style -> {
            if (e != null) {
                return style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)new class_2585(e.getMessage()).method_27692(class_124.field_1061)));
            }
            return style;
        }), class_156.field_25140);
    }

    private void onDisconnect() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
        ClientCompatibilityManager.INSTANCE.emitVoiceChatDisconnectedEvent();
    }

    private void onPublishServer(int port) {
        Server server = Voicechat.SERVER.getServer();
        if (server == null) {
            return;
        }
        try {
            ClientVoicechatConnection connection;
            Voicechat.LOGGER.info("Changing voice chat port to {}", (Object)port);
            server.changePort(port);
            ClientVoicechat client = ClientManager.getClient();
            if (client != null && (connection = client.getConnection()) != null) {
                Voicechat.LOGGER.info("Force disconnecting due to port change");
                connection.disconnect();
            }
            NetManager.sendToServer(new RequestSecretPacket(Voicechat.COMPATIBILITY_VERSION));
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to change voice chat port: {}", (Object)e.getMessage());
        }
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)new class_2588("message.voicechat.server_port", new Object[]{server.getPort()}));
    }

    public void checkMicrophonePermissions() {
        AVAuthorizationStatus status;
        if (!VoicechatClient.CLIENT_CONFIG.macosMicrophoneWorkaround.get().booleanValue()) {
            return;
        }
        if (Platform.isMac() && !(status = PermissionCheck.getMicrophonePermissions()).equals((Object)AVAuthorizationStatus.AUTHORIZED)) {
            ClientManager.sendPlayerError("message.voicechat.macos_no_mic_permission", null);
            Voicechat.LOGGER.warn("User hasn't granted microphone permissions: {}", (Object)status.name());
        }
    }

    @Nullable
    public static ClientVoicechat getClient() {
        return ClientManager.instance().client;
    }

    public static ClientPlayerStateManager getPlayerStateManager() {
        return ClientManager.instance().playerStateManager;
    }

    public static PTTKeyHandler getPttKeyHandler() {
        return ClientManager.instance().pttKeyHandler;
    }

    public static RenderEvents getRenderEvents() {
        return ClientManager.instance().renderEvents;
    }

    public KeyEvents getKeyEvents() {
        return this.keyEvents;
    }

    public static ClientManager instance() {
        if (instance == null) {
            instance = new ClientManager();
        }
        return instance;
    }
}

