/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.model;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.ProcessingDataKey;
import me.pepperbell.continuity.api.client.ProcessingDataKeyRegistry;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.config.ContinuityConfig;
import me.pepperbell.continuity.client.util.RenderUtil;
import me.pepperbell.continuity.impl.client.ProcessingDataKeyRegistryImpl;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class CTMBakedModel
extends ForwardingBakedModel {
    public static final int MULTIPASS_LIMIT = 3;
    protected static final ThreadLocal<ObjectContainer> CONTAINERS = ThreadLocal.withInitial(ObjectContainer::new);
    protected final List<QuadProcessor> processors;
    @Nullable
    protected final List<QuadProcessor> multipassProcessors;

    public CTMBakedModel(class_1087 wrapped, List<QuadProcessor> processors, @Nullable List<QuadProcessor> multipassProcessors) {
        this.wrapped = wrapped;
        this.processors = processors;
        this.multipassProcessors = multipassProcessors;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, RenderContext context) {
        if (((Boolean)ContinuityConfig.INSTANCE.disableCTM.get()).booleanValue()) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        ObjectContainer container = CONTAINERS.get();
        if (container.ctmDisabled) {
            super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
            return;
        }
        CTMQuadTransform quadTransform = container.quadTransform;
        quadTransform.prepare(this.processors, this.multipassProcessors, state, blockView, pos, randomSupplier, (Boolean)ContinuityConfig.INSTANCE.useManualCulling.get());
        context.pushTransform((RenderContext.QuadTransform)quadTransform);
        super.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
        quadTransform.processingContext.accept(context);
        quadTransform.reset();
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public static boolean isCTMDisabled() {
        return CTMBakedModel.CONTAINERS.get().ctmDisabled;
    }

    public static void setCTMDisabled(boolean disabled) {
        CTMBakedModel.CONTAINERS.get().ctmDisabled = disabled;
    }

    protected static class ObjectContainer {
        public boolean ctmDisabled = false;
        public CTMQuadTransform quadTransform = new CTMQuadTransform();

        protected ObjectContainer() {
        }
    }

    protected static class CTMQuadTransform
    implements RenderContext.QuadTransform {
        protected final CullingCache cullingCache = new CullingCache();
        protected final ProcessingContextImpl processingContext = new ProcessingContextImpl();
        protected List<QuadProcessor> processors;
        protected List<QuadProcessor> multipassProcessors;
        protected class_2680 state;
        protected class_1920 blockView;
        protected class_2338 pos;
        protected Supplier<Random> randomSupplier;
        protected boolean useManualCulling;
        protected SpriteFinder spriteFinder;

        protected CTMQuadTransform() {
        }

        public boolean transform(MutableQuadView quad) {
            class_2350 cullFace;
            if (this.useManualCulling && (cullFace = quad.cullFace()) != null && this.cullingCache.shouldCull(this.blockView, this.pos, this.state, cullFace)) {
                return false;
            }
            Boolean result = this.transformOnce(quad, this.processors, 0);
            if (result != null) {
                return result;
            }
            if (this.multipassProcessors != null) {
                for (int pass = 0; pass < 3; ++pass) {
                    result = this.transformOnce(quad, this.multipassProcessors, pass + 1);
                    if (result == null) continue;
                    return result;
                }
            }
            return true;
        }

        protected Boolean transformOnce(MutableQuadView quad, List<QuadProcessor> processors, int pass) {
            class_1058 sprite = this.spriteFinder.find((QuadView)quad, 0);
            int amount = processors.size();
            for (int i = 0; i < amount; ++i) {
                QuadProcessor processor = processors.get(i);
                QuadProcessor.ProcessingResult result = processor.processQuad(quad, sprite, this.blockView, this.state, this.pos, this.randomSupplier, pass, i, this.processingContext);
                if (result == QuadProcessor.ProcessingResult.CONTINUE) continue;
                if (result == QuadProcessor.ProcessingResult.STOP) {
                    return null;
                }
                if (result == QuadProcessor.ProcessingResult.ABORT_AND_CANCEL_QUAD) {
                    return false;
                }
                if (result != QuadProcessor.ProcessingResult.ABORT_AND_RENDER_QUAD) continue;
                return true;
            }
            return true;
        }

        public void prepare(List<QuadProcessor> processors, List<QuadProcessor> multipassProcessors, class_2680 state, class_1920 blockView, class_2338 pos, Supplier<Random> randomSupplier, boolean useManualCulling) {
            this.processors = processors;
            this.multipassProcessors = multipassProcessors;
            this.state = state;
            this.blockView = blockView;
            this.pos = pos;
            this.randomSupplier = randomSupplier;
            this.useManualCulling = useManualCulling;
            this.spriteFinder = RenderUtil.getSpriteFinder();
            this.cullingCache.prepare();
        }

        public void reset() {
            this.processors = null;
            this.multipassProcessors = null;
            this.state = null;
            this.blockView = null;
            this.pos = null;
            this.randomSupplier = null;
            this.useManualCulling = false;
            this.spriteFinder = null;
            this.processingContext.reset();
        }
    }

    protected static class ProcessingContextImpl
    implements QuadProcessor.ProcessingContext {
        protected List<Consumer<QuadEmitter>> emitterConsumers = new ObjectArrayList();
        protected List<Mesh> meshes = new ObjectArrayList();
        protected Object[] processingData = new Object[ProcessingDataKeyRegistry.INSTANCE.getRegisteredAmount()];

        protected ProcessingContextImpl() {
        }

        @Override
        public void addEmitterConsumer(Consumer<QuadEmitter> consumer) {
            this.emitterConsumers.add(consumer);
        }

        @Override
        public void addMesh(Mesh mesh) {
            this.meshes.add(mesh);
        }

        @Override
        public <T> T getData(ProcessingDataKey<T> key) {
            int index = key.getRawId();
            Object data = this.processingData[index];
            if (data == null) {
                this.processingData[index] = data = key.getValueSupplier().get();
            }
            return (T)data;
        }

        public <T> T getDataOrNull(ProcessingDataKey<T> key) {
            return (T)this.processingData[key.getRawId()];
        }

        public void accept(RenderContext context) {
            int i;
            int amount;
            if (!this.emitterConsumers.isEmpty()) {
                QuadEmitter quadEmitter = context.getEmitter();
                amount = this.emitterConsumers.size();
                for (i = 0; i < amount; ++i) {
                    this.emitterConsumers.get(i).accept(quadEmitter);
                }
            }
            if (!this.meshes.isEmpty()) {
                Consumer meshConsumer = context.meshConsumer();
                amount = this.meshes.size();
                for (i = 0; i < amount; ++i) {
                    meshConsumer.accept(this.meshes.get(i));
                }
            }
        }

        protected void resetData() {
            List<ProcessingDataKey<?>> allResetable = ProcessingDataKeyRegistryImpl.INSTANCE.getAllResetable();
            int amount = allResetable.size();
            for (int i = 0; i < amount; ++i) {
                this.resetData(allResetable.get(i));
            }
        }

        protected <T> void resetData(ProcessingDataKey<T> key) {
            T value = this.getDataOrNull(key);
            if (value != null) {
                key.getValueResetAction().accept(value);
            }
        }

        public void reset() {
            this.emitterConsumers.clear();
            this.meshes.clear();
            this.resetData();
        }
    }

    protected static class CullingCache {
        protected int completionFlags;
        protected int resultFlags;
        protected class_2338.class_2339 mutablePos = new class_2338.class_2339();

        protected CullingCache() {
        }

        public boolean shouldCull(class_1920 blockView, class_2338 pos, class_2680 state, class_2350 cullFace) {
            int mask = 1 << cullFace.ordinal();
            if ((this.completionFlags & mask) == 0) {
                this.completionFlags |= mask;
                if (class_2248.method_9607((class_2680)state, (class_1922)blockView, (class_2338)pos, (class_2350)cullFace, (class_2338)this.mutablePos.method_25505((class_2382)pos, cullFace))) {
                    this.resultFlags |= mask;
                    return false;
                }
                return true;
            }
            return (this.resultFlags & mask) == 0;
        }

        public void prepare() {
            this.completionFlags = 0;
            this.resultFlags = 0;
        }
    }
}

