/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.impl.client;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.ProcessingDataKey;
import me.pepperbell.continuity.api.client.ProcessingDataKeyRegistry;
import me.pepperbell.continuity.impl.client.ProcessingDataKeyImpl;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ProcessingDataKeyRegistryImpl
implements ProcessingDataKeyRegistry {
    public static final ProcessingDataKeyRegistryImpl INSTANCE = new ProcessingDataKeyRegistryImpl();
    private final Map<class_2960, ProcessingDataKey<?>> keyMap = new Object2ObjectOpenHashMap();
    private final List<ProcessingDataKey<?>> allResetable = new ObjectArrayList();
    private final List<ProcessingDataKey<?>> allResetableView = Collections.unmodifiableList(this.allResetable);
    private int registeredAmount = 0;
    private boolean registrationLocked;

    @Override
    public <T> ProcessingDataKey<T> registerKey(class_2960 id, Supplier<T> valueSupplier, Consumer<T> valueResetAction) {
        if (this.registrationLocked) {
            throw new IllegalArgumentException("Cannot register processing data key for ID '" + id + "' as the client has already started");
        }
        ProcessingDataKey<?> oldKey = this.keyMap.get(id);
        if (oldKey != null) {
            throw new IllegalArgumentException("Cannot override processing data key registration for ID '" + id + "'");
        }
        ProcessingDataKeyImpl<T> key = new ProcessingDataKeyImpl<T>(id, this.registeredAmount, valueSupplier, valueResetAction);
        this.keyMap.put(id, key);
        if (valueResetAction != null) {
            this.allResetable.add(key);
        }
        ++this.registeredAmount;
        return key;
    }

    @Override
    @Nullable
    public ProcessingDataKey<?> getKey(class_2960 id) {
        return this.keyMap.get(id);
    }

    @Override
    public int getRegisteredAmount() {
        return this.registeredAmount;
    }

    public List<ProcessingDataKey<?>> getAllResetable() {
        return this.allResetableView;
    }

    public void lockRegistration() {
        this.registrationLocked = true;
    }
}

