/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.entity.collisions.unpushable_cramming;

import java.util.ArrayList;
import java.util.Iterator;
import me.jellysquid.mods.lithium.common.entity.pushable.BlockCachingEntity;
import me.jellysquid.mods.lithium.common.entity.pushable.EntityPushablePredicate;
import me.jellysquid.mods.lithium.common.entity.pushable.PushableEntityClassGroup;
import me.jellysquid.mods.lithium.common.util.collections.MaskedList;
import me.jellysquid.mods.lithium.common.world.ClimbingMobCachingSection;
import net.minecraft.class_1297;
import net.minecraft.class_1510;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3509;
import net.minecraft.class_5568;
import net.minecraft.class_5572;
import net.minecraft.class_5584;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_5572.class})
public abstract class EntityTrackingSectionMixin<T extends class_5568>
implements ClimbingMobCachingSection {
    @Shadow
    @Final
    private class_3509<T> field_27248;
    @Shadow
    private class_5584 field_27249;
    @Unique
    private MaskedList<class_1297> pushableEntities;

    @Override
    public void collectPushableEntities(class_1937 world, class_1297 except, class_238 box, EntityPushablePredicate<? super class_1297> entityPushablePredicate, ArrayList<class_1297> entities) {
        Iterator entityIterator = this.pushableEntities != null ? this.pushableEntities.iterator() : this.field_27248.iterator();
        int i = 0;
        int j = 0;
        while (entityIterator.hasNext()) {
            class_1297 entity = (class_1297)entityIterator.next();
            if (!entity.method_5829().method_994(box) || entity.method_7325() || entity == except || entity instanceof class_1510) continue;
            ++i;
            if (!entityPushablePredicate.test(entity)) continue;
            ++j;
            entities.add(entity);
        }
        if (this.pushableEntities == null && i >= 25 && i >= j * 2) {
            this.startFilteringPushableEntities();
        }
    }

    private void startFilteringPushableEntities() {
        this.pushableEntities = new MaskedList();
        for (class_5568 entity : this.field_27248) {
            this.onStartClimbingCachingEntity((class_1297)entity);
        }
    }

    private void stopFilteringPushableEntities() {
        this.pushableEntities = null;
    }

    @Override
    public void onEntityModifiedCachedBlock(BlockCachingEntity entity, class_2680 newBlockState) {
        if (this.pushableEntities == null) {
            entity.lithiumSetClimbingMobCachingSectionUpdateBehavior(false);
        } else {
            this.updatePushabilityOnCachedStateChange(entity, newBlockState);
        }
    }

    private void updatePushabilityOnCachedStateChange(BlockCachingEntity entity, class_2680 newBlockState) {
        boolean visible = EntityTrackingSectionMixin.entityPushableHeuristic(newBlockState);
        this.pushableEntities.setVisible((class_1297)entity, visible);
    }

    private void onStartClimbingCachingEntity(class_1297 entity) {
        Class<?> entityClass = entity.getClass();
        if (PushableEntityClassGroup.MAYBE_PUSHABLE.contains(entityClass)) {
            this.pushableEntities.add(entity);
            boolean shouldTrackBlockChanges = PushableEntityClassGroup.CACHABLE_UNPUSHABILITY.contains(entityClass);
            if (shouldTrackBlockChanges) {
                BlockCachingEntity blockCachingEntity = (BlockCachingEntity)entity;
                this.updatePushabilityOnCachedStateChange(blockCachingEntity, blockCachingEntity.getCachedFeetBlockState());
                blockCachingEntity.lithiumSetClimbingMobCachingSectionUpdateBehavior(true);
            }
        }
    }

    @Inject(method={"add(Lnet/minecraft/world/entity/EntityLike;)V"}, at={@At(value="RETURN")})
    private void onEntityAdded(T entityLike, CallbackInfo ci) {
        if (this.pushableEntities != null) {
            if (!this.field_27249.method_31885()) {
                this.stopFilteringPushableEntities();
            } else {
                this.onStartClimbingCachingEntity((class_1297)entityLike);
            }
        }
    }

    @ModifyVariable(method={"remove(Lnet/minecraft/world/entity/EntityLike;)Z"}, at=@At(value="RETURN"), argsOnly=true)
    private T onEntityRemoved(T entityLike) {
        if (this.pushableEntities != null) {
            if (!this.field_27249.method_31885()) {
                this.stopFilteringPushableEntities();
            } else {
                this.pushableEntities.remove((class_1297)entityLike);
            }
        }
        return entityLike;
    }

    private static boolean entityPushableHeuristic(class_2680 cachedFeetBlockState) {
        return cachedFeetBlockState == null || !cachedFeetBlockState.method_26164(class_3481.field_22414);
    }
}

