/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class CursorBox {
    private static final int BOX_OFFSET_X = 12;
    private static final int BOX_OFFSET_Y = -10;
    private static final int START_WIDTH = 20;
    private static final int USUAL_WIDTH = 200;
    private ArrayList<class_2561> strings;
    private class_2561 directText;
    private boolean directTextReady;
    private String language;
    private String fullCode;
    private class_2583 codeStyle;
    private String plainText;
    private int boxWidth = 20;
    private static final int color = -939524096;
    private boolean customLines;
    private boolean flippedByDefault;
    private boolean autoLinebreak;

    public CursorBox(String code) {
        this(code, class_2583.field_24360);
    }

    public CursorBox(String code, class_2583 codeStyle) {
        this(code, codeStyle, false);
    }

    public CursorBox(String code, class_2583 codeStyle, boolean flippedByDefault) {
        this.fullCode = code;
        this.codeStyle = codeStyle;
        this.flippedByDefault = flippedByDefault;
        this.autoLinebreak = true;
    }

    public CursorBox(class_2561 directText) {
        this(directText, false);
    }

    public CursorBox(class_2561 directText, boolean flippedByDefault) {
        this.directText = directText;
        this.flippedByDefault = flippedByDefault;
        this.autoLinebreak = true;
    }

    public CursorBox(int size) {
        this.strings = new ArrayList();
        for (int i = 0; i < size; ++i) {
            this.strings.add((class_2561)new class_2585(""));
        }
        this.customLines = true;
    }

    public void setBoxWidth(int boxWidth) {
        this.boxWidth = boxWidth;
    }

    private String currentLanguage() {
        return class_310.method_1551().method_1526().method_4669().getCode();
    }

    public void createLines(class_2561 text) {
        try {
            this.language = this.currentLanguage();
        }
        catch (NullPointerException e) {
            this.language = "en_us";
        }
        this.strings = new ArrayList();
        SplitProgress progress = new SplitProgress();
        int spaceWidth = class_310.method_1551().field_1772.method_1727(" ");
        this.splitWords(this.strings, progress, spaceWidth, (class_5348)text);
    }

    public void splitWords(ArrayList<class_2561> dest, SplitProgress progress, int spaceWidth, class_5348 formattedText) {
        StringBuilder plainTextBuilder = new StringBuilder();
        class_5348.class_5246 consumer = (style, text) -> {
            plainTextBuilder.append(text);
            boolean endsWithSpace = ((String)text).endsWith(" ");
            if (endsWithSpace) {
                text = (String)text + ".";
            }
            String[] parts = ((String)text).split(" ");
            boolean isEnd = style == null;
            int widthLimit = this.autoLinebreak ? 200 : Integer.MAX_VALUE;
            for (int i = 0; i < parts.length; ++i) {
                boolean isNewLine;
                boolean canAddMultiword = isEnd || i < parts.length - 1;
                String part = isEnd || endsWithSpace && i == parts.length - 1 ? "" : parts[i];
                int partWidth = class_310.method_1551().field_1772.method_1727(part);
                if (!canAddMultiword) {
                    progress.buildMultiword(part, partWidth, style);
                    continue;
                }
                int wordWidth = partWidth + progress.multiwordWidth;
                int wordTakesWidth = wordWidth + (!progress.firstWord ? spaceWidth : 0);
                if (progress.lineWidth + wordTakesWidth <= widthLimit - 20) {
                    this.boxWidth = Math.max(this.boxWidth, Math.min(widthLimit, progress.lineWidth + wordTakesWidth + 20));
                }
                if (progress.firstWord && progress.lineWidth + wordTakesWidth > this.boxWidth - 20) {
                    this.boxWidth = progress.lineWidth + wordTakesWidth + 20;
                }
                boolean bl = isNewLine = progress.multiword == null && part.equals("\n");
                if (!isNewLine && progress.lineWidth + wordTakesWidth <= this.boxWidth - 20) {
                    progress.confirmWord(part, style, wordTakesWidth);
                    continue;
                }
                progress.confirmComponent();
                dest.add(progress.line);
                progress.nextLine();
                if (isNewLine) continue;
                --i;
            }
            return Optional.empty();
        };
        formattedText.method_27658(consumer, class_2583.field_24360.method_10977(class_124.field_1068));
        if (progress.multiword != null) {
            consumer.accept(null, "end");
        } else if (progress.stringBuilder.length() > 0) {
            progress.confirmComponent();
        }
        if (progress.line != null) {
            dest.add(progress.line);
        }
        if (this.boxWidth > 20) {
            --this.boxWidth;
        }
        this.plainText = plainTextBuilder.toString();
    }

    public class_2561 getLine(int line) {
        return this.strings.get(line);
    }

    private void ensure() {
        try {
            if (!(this.customLines || (this.fullCode != null || this.directTextReady) && this.language != null && this.language.equals(this.currentLanguage()))) {
                if (this.fullCode != null) {
                    this.createLines((class_2561)new class_2588(this.fullCode).method_27696(this.codeStyle));
                } else {
                    this.createLines(this.directText);
                    this.directTextReady = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawBox(class_4587 matrixStack, int x, int y, int width, int height) {
        int h;
        int overEdgeY;
        this.ensure();
        int drawX = x + 12;
        int drawY = y + -10;
        int overEdgeX = drawX + this.boxWidth - width;
        if (this.flippedByDefault || overEdgeX > 9) {
            drawX = x - 12 - this.boxWidth;
        } else if (overEdgeX > 0) {
            drawX -= overEdgeX;
        }
        if (drawX < 0) {
            drawX = 0;
        }
        if ((overEdgeY = drawY + (h = 5 + this.strings.size() * 10 + 5) - height) > h / 2) {
            drawY = y - -10 - h;
        } else if (overEdgeY > 0) {
            drawY -= overEdgeY;
        }
        if (drawY < 0) {
            drawY = 0;
        }
        class_332.method_25294((class_4587)matrixStack, (int)drawX, (int)drawY, (int)(drawX + this.boxWidth), (int)(drawY + h), (int)-939524096);
        for (int i = 0; i < this.strings.size(); ++i) {
            class_2561 s = this.getLine(i);
            class_310.method_1551().field_1772.method_30883(matrixStack, s, (float)(drawX + 10), (float)(drawY + 6 + 10 * i), 0xFFFFFF);
        }
    }

    public CursorBox withWidth(int boxWidth) {
        this.boxWidth = boxWidth;
        return this;
    }

    public void setAutoLinebreak(boolean autoLinebreak) {
        this.autoLinebreak = autoLinebreak;
    }

    public String getPlainText() {
        this.ensure();
        return this.plainText;
    }

    public String getFullCode() {
        return this.fullCode;
    }

    public class SplitProgress {
        int multiwordWidth;
        List<class_5250> multiword = null;
        boolean firstWord = true;
        class_2561 line = null;
        StringBuilder stringBuilder = new StringBuilder();
        int lineWidth;
        class_2583 lastStyle;

        public void buildMultiword(String wordPart, int width, class_2583 style) {
            class_5250 wordPartComponent = new class_2585(wordPart).method_27696(style);
            if (this.multiword == null) {
                this.multiword = new ArrayList<class_5250>();
            }
            this.multiword.add(wordPartComponent);
            this.multiwordWidth += width;
        }

        private void confirmWordPart(String part, class_2583 style) {
            if (this.lastStyle != null && !Objects.equals(style, this.lastStyle)) {
                this.confirmComponent();
            }
            this.stringBuilder.append(part);
            this.lastStyle = style;
        }

        public void confirmWord(String lastPart, class_2583 lastPartStyle, int width) {
            if (!this.firstWord) {
                this.stringBuilder.append(" ");
            }
            if (this.multiword != null) {
                for (class_2561 class_25612 : this.multiword) {
                    String text = class_25612.method_10851();
                    class_2583 style = class_25612.method_10866();
                    this.confirmWordPart(text, style);
                }
                this.multiword = null;
                this.multiwordWidth = 0;
            }
            this.confirmWordPart(lastPart, lastPartStyle);
            this.lineWidth += width;
            this.firstWord = false;
        }

        public void confirmComponent() {
            class_5250 comp = new class_2585(this.stringBuilder.toString()).method_27696(this.lastStyle == null ? class_2583.field_24360 : this.lastStyle);
            if (this.line != null) {
                if (this.stringBuilder.length() > 0) {
                    this.line.method_10855().add(comp);
                }
            } else {
                this.line = comp;
            }
            this.stringBuilder.delete(0, this.stringBuilder.length());
        }

        public void nextLine() {
            this.firstWord = true;
            this.line = null;
            this.lastStyle = null;
            this.lineWidth = 0;
        }
    }
}

