/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.element;

import net.minecraft.class_310;
import xaero.map.element.MapElementRenderer;
import xaero.map.gui.GuiMap;
import xaero.map.gui.IRightClickableElement;

public abstract class MapElement<R extends MapElementRenderer<?, R>>
implements IRightClickableElement {
    private final R renderer;

    protected MapElement(R renderer) {
        this.renderer = renderer;
    }

    public abstract boolean isHidden(R var1, GuiMap var2);

    public abstract double getScale();

    public abstract double getRenderX();

    public abstract double getRenderZ();

    public abstract int boundingBoxLeft();

    public abstract int boundingBoxRight();

    public abstract int boundingBoxTop();

    public abstract int boundingBoxBottom();

    public abstract int getLeftSideLength(class_310 var1);

    public abstract String getMenuName();

    public abstract String getFilterName();

    public abstract int getMenuTextFillLeftPadding();

    public boolean isMouseOverMenuElement(int x, int y, int mouseX, int mouseY, class_310 mc) {
        int topEdge = y - 8;
        if (mouseY < topEdge) {
            return false;
        }
        int bottomEdge = y + 8;
        if (mouseY >= bottomEdge) {
            return false;
        }
        int rightEdge = x + 5;
        if (mouseX >= rightEdge) {
            return false;
        }
        int leftEdge = x - this.getLeftSideLength(mc);
        return mouseX >= leftEdge;
    }

    public boolean isHoveredOnMap(double mouseX, double mouseZ, double scale, double rendererScale, double guiBasedScale) {
        double fullScale = rendererScale * this.getScale() * guiBasedScale;
        double left = (double)this.boundingBoxLeft() * fullScale;
        double right = (double)this.boundingBoxRight() * fullScale;
        double top = (double)this.boundingBoxTop() * fullScale;
        double bottom = (double)this.boundingBoxBottom() * fullScale;
        double screenOffX = (mouseX - this.getRenderX()) * scale;
        if (screenOffX < left || screenOffX > right) {
            return false;
        }
        double screenOffY = (mouseZ - this.getRenderZ()) * scale;
        return !(screenOffY < top) && !(screenOffY > bottom);
    }

    public boolean isOnScreen(double cameraX, double cameraZ, int width, int height, double scale) {
        double xOnScreen = (this.getRenderX() - cameraX) * scale + (double)(width / 2);
        double zOnScreen = (this.getRenderZ() - cameraZ) * scale + (double)(height / 2);
        return xOnScreen < (double)width && xOnScreen > 0.0 && zOnScreen < (double)height && zOnScreen > 0.0;
    }

    public R getRenderer() {
        return this.renderer;
    }
}

