/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1159;
import net.minecraft.class_277;
import net.minecraft.class_285;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.graphics.shader.MapShaders;

public class MapRenderHelper {
    private static class_277 defaultShaderDisabledBlendState = new class_277();
    private static class_277 defaultShaderBlendState = new class_277(770, 771, 32774);

    public static void renderBranchUpdate(float x, float y, float width, float height, int textureX, int textureY, float textureW, float textureH, float fullTextureWidth, float fullTextureHeight, boolean first) {
        RenderSystem.setShader(() -> MapShaders.WORLD_MAP_BRANCH);
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        vertexBuffer.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        float normalizedTextureX = (float)textureX / fullTextureWidth;
        float normalizedTextureY = (float)textureY / fullTextureHeight;
        float normalizedTextureX2 = ((float)textureX + textureW) / fullTextureWidth;
        float normalizedTextureY2 = ((float)textureY + textureH) / fullTextureHeight;
        vertexBuffer.method_22912((double)(x + 0.0f), (double)(y + height), 0.0).method_22913(normalizedTextureX, normalizedTextureY2).method_1344();
        vertexBuffer.method_22912((double)(x + width), (double)(y + height), 0.0).method_22913(normalizedTextureX2, normalizedTextureY2).method_1344();
        vertexBuffer.method_22912((double)(x + width), (double)(y + 0.0f), 0.0).method_22913(normalizedTextureX2, normalizedTextureY).method_1344();
        vertexBuffer.method_22912((double)(x + 0.0f), (double)(y + 0.0f), 0.0).method_22913(normalizedTextureX, normalizedTextureY).method_1344();
        vertexBuffer.method_1326();
        if (first) {
            class_286.method_1309((class_287)vertexBuffer);
            class_285.method_22094((int)MapShaders.WORLD_MAP_BRANCH.method_1270());
        } else {
            class_286.method_34424((class_287)vertexBuffer);
        }
    }

    public static void fillIntoExistingBuffer(class_1159 matrix, class_4588 bufferBuilder, int x1, int y1, int x2, int y2, float r, float g, float b, float a) {
        bufferBuilder.method_22918(matrix, (float)x1, (float)y2, 0.0f).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y2, 0.0f).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22918(matrix, (float)x2, (float)y1, 0.0f).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(r, g, b, a).method_1344();
    }

    public static void blitIntoExistingBuffer(class_1159 matrix, class_4588 bufferBuilder, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a, int textureWidth, int textureHeight) {
        float factorX = 1.0f / (float)textureWidth;
        float factorY = 1.0f / (float)textureHeight;
        float textureX1 = (float)u * factorX;
        float textureX2 = (float)(u + width) * factorX;
        float textureY1 = (float)v * factorY;
        float textureY2 = (float)(v + height) * factorY;
        bufferBuilder.method_22918(matrix, (float)x, (float)(y + height), 0.0f).method_22915(r, g, b, a).method_22913(textureX1, textureY2).method_1344();
        bufferBuilder.method_22918(matrix, (float)(x + width), (float)(y + height), 0.0f).method_22915(r, g, b, a).method_22913(textureX2, textureY2).method_1344();
        bufferBuilder.method_22918(matrix, (float)(x + width), (float)y, 0.0f).method_22915(r, g, b, a).method_22913(textureX2, textureY1).method_1344();
        bufferBuilder.method_22918(matrix, (float)x, (float)y, 0.0f).method_22915(r, g, b, a).method_22913(textureX1, textureY1).method_1344();
    }

    public static void blitIntoExistingBuffer(class_1159 matrix, class_4588 bufferBuilder, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a) {
        MapRenderHelper.blitIntoExistingBuffer(matrix, bufferBuilder, x, y, u, v, width, height, r, g, b, a, 256, 256);
    }

    public static void blitIntoMultiTextureRenderer(class_1159 matrix, MultiTextureRenderTypeRenderer renderer, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a, int textureWidth, int textureHeight, int texture) {
        class_287 bufferBuilder = renderer.begin(class_293.class_5596.field_27382, class_290.field_20887, texture);
        MapRenderHelper.blitIntoExistingBuffer(matrix, (class_4588)bufferBuilder, x, y, u, v, width, height, r, g, b, a, textureWidth, textureHeight);
    }

    public static void blitIntoMultiTextureRenderer(class_1159 matrix, MultiTextureRenderTypeRenderer renderer, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a, int texture) {
        MapRenderHelper.blitIntoMultiTextureRenderer(matrix, renderer, x, y, u, v, width, height, r, g, b, a, 256, 256, texture);
    }

    public static void renderDynamicHighlight(class_4587 matrixStack, class_4588 overlayBuffer, int flooredCameraX, int flooredCameraZ, int leftX, int rightX, int topZ, int bottomZ, float sideR, float sideG, float sideB, float sideA, float centerR, float centerG, float centerB, float centerA) {
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.method_23760().method_23761(), overlayBuffer, leftX - 1 - flooredCameraX, topZ - 1 - flooredCameraZ, leftX - flooredCameraX, bottomZ + 1 - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.method_23760().method_23761(), overlayBuffer, leftX - flooredCameraX, topZ - 1 - flooredCameraZ, rightX - flooredCameraX, topZ - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.method_23760().method_23761(), overlayBuffer, rightX - flooredCameraX, topZ - 1 - flooredCameraZ, rightX + 1 - flooredCameraX, bottomZ + 1 - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.method_23760().method_23761(), overlayBuffer, leftX - flooredCameraX, bottomZ - flooredCameraZ, rightX - flooredCameraX, bottomZ + 1 - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.method_23760().method_23761(), overlayBuffer, leftX - flooredCameraX, topZ - flooredCameraZ, rightX - flooredCameraX, bottomZ - flooredCameraZ, centerR, centerG, centerB, centerA);
    }

    public static void blitIntoExistingBuffer(class_1159 matrix, class_4588 bufferBuilder, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        float factorX = 1.0f / (float)textureWidth;
        float factorY = 1.0f / (float)textureHeight;
        float textureX1 = (float)u * factorX;
        float textureX2 = (float)(u + width) * factorX;
        float textureY1 = (float)v * factorY;
        float textureY2 = (float)(v + height) * factorY;
        bufferBuilder.method_22918(matrix, (float)x, (float)(y + height), 0.0f).method_22913(textureX1, textureY2).method_1344();
        bufferBuilder.method_22918(matrix, (float)(x + width), (float)(y + height), 0.0f).method_22913(textureX2, textureY2).method_1344();
        bufferBuilder.method_22918(matrix, (float)(x + width), (float)y, 0.0f).method_22913(textureX2, textureY1).method_1344();
        bufferBuilder.method_22918(matrix, (float)x, (float)y, 0.0f).method_22913(textureX1, textureY1).method_1344();
    }

    public static void blitIntoExistingBuffer(class_1159 matrix, class_4588 bufferBuilder, int x, int y, int u, int v, int width, int height) {
        MapRenderHelper.blitIntoExistingBuffer(matrix, bufferBuilder, x, y, u, v, width, height, 256, 256);
    }

    public static void blitIntoMultiTextureRenderer(class_1159 matrix, MultiTextureRenderTypeRenderer renderer, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int texture) {
        class_287 bufferBuilder = renderer.begin(class_293.class_5596.field_27382, class_290.field_1585, texture);
        MapRenderHelper.blitIntoExistingBuffer(matrix, (class_4588)bufferBuilder, x, y, u, v, width, height, textureWidth, textureHeight);
    }

    public static void blitIntoMultiTextureRenderer(class_1159 matrix, MultiTextureRenderTypeRenderer renderer, int x, int y, int u, int v, int width, int height, int texture) {
        MapRenderHelper.blitIntoMultiTextureRenderer(matrix, renderer, x, y, u, v, width, height, 256, 256, texture);
    }

    public static void restoreDefaultShaderBlendState() {
        defaultShaderDisabledBlendState.method_1244();
        defaultShaderBlendState.method_1244();
        RenderSystem.defaultBlendFunc();
    }
}

