/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics.renderer.multitexture;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Objects;
import java.util.function.IntConsumer;
import net.minecraft.class_1921;
import net.minecraft.class_285;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_293;

public class MultiTextureRenderTypeRenderer {
    private boolean used;
    private class_287 bufferBuilder = new class_287(256);
    private IntArrayList texturesForDrawCalls = new IntArrayList();
    private IntConsumer textureBinderShader;
    private IntConsumer textureBinder;
    private int prevTextureId;
    private class_293 prevFormat;
    private class_1921 renderType;

    MultiTextureRenderTypeRenderer() {
    }

    void init(IntConsumer textureBinderShader, IntConsumer textureBinder, class_1921 renderType) {
        if (this.used) {
            throw new IllegalStateException("Multi-texture renderer already in use!");
        }
        this.used = true;
        this.textureBinderShader = textureBinderShader;
        this.textureBinder = textureBinder;
        this.prevTextureId = -1;
        this.renderType = renderType;
    }

    void draw() {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (!this.texturesForDrawCalls.isEmpty()) {
            class_287 bufferBuilder = this.bufferBuilder;
            IntConsumer textureBinder = this.textureBinder;
            IntConsumer textureBinderShader = this.textureBinderShader;
            this.renderType.method_23516();
            bufferBuilder.method_1326();
            boolean first = true;
            int shaderProgram = RenderSystem.getShader().method_1270();
            for (Integer texture : this.texturesForDrawCalls) {
                if (first) {
                    textureBinderShader.accept(texture);
                    class_286.method_1309((class_287)bufferBuilder);
                    class_285.method_22094((int)shaderProgram);
                    first = false;
                    continue;
                }
                textureBinder.accept(texture);
                class_286.method_34424((class_287)bufferBuilder);
            }
            textureBinderShader.accept(0);
            textureBinder.accept(0);
            this.renderType.method_23518();
        }
        class_285.method_22094((int)0);
        this.texturesForDrawCalls.clear();
        this.used = false;
        this.renderType = null;
    }

    public class_287 begin(class_293.class_5596 mode, class_293 format, int textureId) {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (textureId == -1) {
            throw new IllegalStateException("Attempted to use the multi-texture renderer with texture id -1!");
        }
        if (textureId != this.prevTextureId || !Objects.equals(this.prevFormat, format)) {
            if (this.prevTextureId != -1) {
                this.bufferBuilder.method_1326();
            }
            this.bufferBuilder.method_1328(mode, format);
            this.prevTextureId = textureId;
            this.prevFormat = format;
            this.texturesForDrawCalls.add(textureId);
        }
        return this.bufferBuilder;
    }
}

