/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.class_437;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.RightClickOption;

public class GuiRightClickMenu
extends GuiDropDown {
    private IRightClickableElement target;
    private Consumer<GuiRightClickMenu> closedCallback;
    private ArrayList<RightClickOption> actionOptions;
    private class_437 screen;
    private boolean removed;

    private GuiRightClickMenu(IRightClickableElement target, ArrayList<RightClickOption> options, class_437 screen, int x, int y, int w, int titleBackgroundColor, Consumer<GuiRightClickMenu> closedCallback) {
        super(options.stream().map(o -> o.getDisplayName()).collect(ArrayList::new, ArrayList::add, ArrayList::addAll).toArray(new String[0]), x - (GuiRightClickMenu.shouldOpenLeft(options.size(), x, w, screen.field_22789) ? w : 0), y, w, -1, false, null, false);
        this.openingUp = GuiRightClickMenu.shouldOpenUp(options.size(), y, screen.field_22790);
        this.target = target;
        this.screen = screen;
        this.closedCallback = closedCallback;
        this.setClosed(false);
        this.actionOptions = options;
        this.selectedBackground = this.selectedHoveredBackground = titleBackgroundColor;
        this.shortenFromTheRight = true;
    }

    private static boolean shouldOpenLeft(int optionCount, int x, int w, int screenWidth) {
        return x + w - screenWidth > 0;
    }

    private static boolean shouldOpenUp(int optionCount, int y, int screenHeight) {
        int potentialHeight = 11 * optionCount;
        return y + potentialHeight - screenHeight > potentialHeight / 2;
    }

    @Override
    public void setClosed(boolean closed) {
        if (!this.isClosed() && closed) {
            this.removed = true;
            this.closedCallback.accept(this);
        }
        super.setClosed(closed);
    }

    @Override
    public void selectId(int id, boolean callCallback) {
        if (id == -1) {
            return;
        }
        if (this.removed) {
            return;
        }
        this.actionOptions.get(id).onSelected(this.screen);
        this.setClosed(true);
    }

    public static GuiRightClickMenu getMenu(IRightClickableElement rightClickable, class_437 screen, int x, int y, int w, Consumer<GuiRightClickMenu> closedCallback) {
        return new GuiRightClickMenu(rightClickable, rightClickable.getRightClickOptions(), screen, x, y, w, rightClickable.getRightClickTitleBackgroundColor(), closedCallback);
    }

    public IRightClickableElement getTarget() {
        return this.target;
    }
}

