/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.class_1060;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;
import xaero.map.element.MapElement;
import xaero.map.element.MapElementRenderer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.gui.GuiMap;
import xaero.map.icon.XaeroIcon;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportXaeroMinimap;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointSymbolCreator;

public class WaypointRenderer
extends MapElementRenderer<Waypoint, WaypointRenderer> {
    private final SupportXaeroMinimap minimap;
    private final WaypointSymbolCreator symbolCreator;

    public WaypointRenderer(SupportXaeroMinimap minimap, WaypointSymbolCreator symbolCreator) {
        this.minimap = minimap;
        this.symbolCreator = symbolCreator;
    }

    @Override
    public double getRendererScale() {
        return WorldMap.settings.worldmapWaypointsScale;
    }

    public WaypointSymbolCreator getSymbolCreator() {
        return this.symbolCreator;
    }

    @Override
    public Iterator<Waypoint> getElementsToRender() {
        if (!WorldMap.settings.waypoints) {
            return new ArrayList().iterator();
        }
        return this.minimap.getWaypoints().iterator();
    }

    public boolean waypointIsGood(Waypoint w, GuiMap mapScreen) {
        return (w.getType() != 1 && w.getType() != 2 || this.minimap.getDeathpoints()) && (w.isGlobal() || mapScreen.getUserScale() >= WorldMap.settings.minZoomForLocalWaypoints);
    }

    private void renderShadow(Waypoint e, class_4587 matrixStack, double cameraX, double cameraZ, double globalElementScale, class_1060 textureManager, class_4588 regularUIObjectConsumer, float brightness) {
        float elementScale = (float)(globalElementScale * e.getScale());
        matrixStack.method_22903();
        matrixStack.method_22904((double)((float)(e.getRenderX() - cameraX)), (double)((float)(e.getRenderZ() - cameraZ)), 0.0);
        matrixStack.method_22905(elementScale, elementScale, 1.0f);
        e.renderShadow(brightness, regularUIObjectConsumer, matrixStack, textureManager);
        matrixStack.method_22909();
    }

    @Override
    public void renderPre(MapElement<?> hovered, GuiMap mapScreen, class_4587 matrixStack, class_4597.class_4598 renderTypeBuffers, class_4588 regularUIObjectConsumer, MultiTextureRenderTypeRenderer uniqueTextureUIObjectRenderer, class_1060 textureManager, class_327 font, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double baseScale, double scale, double mouseX, double mouseZ, float brightness, MapElement<?> oldHovered, class_310 mc, class_4588 textBGConsumer) {
        super.renderPre(hovered, mapScreen, matrixStack, renderTypeBuffers, regularUIObjectConsumer, uniqueTextureUIObjectRenderer, textureManager, font, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, oldHovered, mc, textBGConsumer);
        if (WorldMap.settings.waypointBackgrounds) {
            double globalElementScale = baseScale * this.getRendererScale();
            Iterator<Waypoint> elements = this.getElementsToRender();
            while (elements.hasNext()) {
                Waypoint e = elements.next();
                if (e.isHidden((WaypointRenderer)this.self, mapScreen) || e == hovered || !e.isOnScreen(cameraX, cameraZ, width, height, scale)) continue;
                this.renderShadow(e, matrixStack, cameraX, cameraZ, globalElementScale, textureManager, regularUIObjectConsumer, brightness);
            }
        }
    }

    @Override
    public void renderHoveredPre(MapElement<?> hovered, GuiMap mapScreen, class_4587 matrixStack, class_4597.class_4598 renderTypeBuffers, class_4588 regularUIObjectConsumer, MultiTextureRenderTypeRenderer uniqueTextureUIObjectRenderer, class_1060 textureManager, class_327 font, double cameraX, double cameraZ, int width, int height, double guiBasedScale, double baseScale, double scale, double mouseX, double mouseZ, float brightness, class_310 mc, class_4588 textBGConsumer) {
        super.renderHoveredPre(hovered, mapScreen, matrixStack, renderTypeBuffers, regularUIObjectConsumer, uniqueTextureUIObjectRenderer, textureManager, font, cameraX, cameraZ, width, height, guiBasedScale, baseScale, scale, mouseX, mouseZ, brightness, mc, textBGConsumer);
        double globalElementScale = baseScale * this.getRendererScale();
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, 0.0, 10.0);
        this.renderShadow((Waypoint)hovered, matrixStack, cameraX, cameraZ, globalElementScale, textureManager, regularUIObjectConsumer, brightness);
        matrixStack.method_22909();
    }

    @Override
    public void renderOnMap(Waypoint w, boolean hovered, class_310 mc, class_4587 matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, double scale, double guiBasedScale, MultiTextureRenderTypeRenderer uniqueTextureUIObjectRenderer, class_1060 textureManager, class_327 fontRenderer, class_4588 textBGConsumer, class_4597.class_4598 renderTypeBuffers, WaypointRenderer renderer) {
        int symbolFrameWidth;
        boolean renderBackground = hovered || WorldMap.settings.waypointBackgrounds;
        matrixStack.method_22903();
        float visibilityAlpha = w.isDisabled() ? 0.3f : 1.0f;
        int color = w.getColor();
        String symbol = w.getSymbol();
        int type = w.getType();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int flagU = 35;
        int flagV = 34;
        int flagW = 30;
        int flagH = 43;
        if (symbol.length() > 1) {
            flagU += 35;
            flagW += 13;
        }
        if (w.isTemporary()) {
            flagU += 83;
        }
        matrixStack.method_22904((double)((float)(-flagW) / 2.0f), (double)(-flagH + 1), 0.0);
        if (renderBackground) {
            MapRenderHelper.blitIntoMultiTextureRenderer(matrixStack.method_23760().method_23761(), uniqueTextureUIObjectRenderer, 0, 0, flagU, flagV, flagW, flagH, red * visibilityAlpha, green * visibilityAlpha, blue * visibilityAlpha, visibilityAlpha, textureManager.method_4619(WorldMap.guiTextures).method_4624());
        }
        matrixStack.method_22909();
        float oldDestAlpha = w.getDestAlpha();
        if (hovered) {
            w.setDestAlpha(255.0f);
        } else {
            w.setDestAlpha(0.0f);
        }
        if (oldDestAlpha != w.getDestAlpha()) {
            w.setAlphaAnim(new SlowingAnimation(w.getAlpha(), w.getDestAlpha(), 0.8, 1.0));
        }
        if (w.getAlphaAnim() != null) {
            w.setAlpha((float)w.getAlphaAnim().getCurrent());
        }
        float alpha = w.getAlpha();
        XaeroIcon symbolIcon = null;
        int symbolVerticalOffset = 0;
        int symbolWidth = 0;
        int stringWidth = fontRenderer.method_1727(symbol);
        int n = symbolFrameWidth = stringWidth / 2 > 4 ? 62 : 32;
        if (type != 1 && alpha < 200.0f) {
            symbolVerticalOffset = 5;
            symbolWidth = (stringWidth - 1) * 3;
            symbolIcon = renderer.getSymbolCreator().getSymbolTexture(symbol);
        } else if (type == 1) {
            symbolVerticalOffset = 3;
            symbolWidth = 27;
            symbolIcon = renderer.getSymbolCreator().getDeathSymbolTexture();
        }
        if (symbolIcon != null) {
            matrixStack.method_22903();
            matrixStack.method_22904((double)(-1.0f - (float)symbolWidth / 2.0f), (double)(62 + (renderBackground ? -43 + symbolVerticalOffset - 1 : -12)), 0.0);
            matrixStack.method_22905(1.0f, -1.0f, 1.0f);
            MapRenderHelper.blitIntoMultiTextureRenderer(matrixStack.method_23760().method_23761(), uniqueTextureUIObjectRenderer, 0, 0, symbolIcon.getOffsetX() + 1, symbolIcon.getOffsetY() + 1, symbolFrameWidth, 62, visibilityAlpha, visibilityAlpha, visibilityAlpha, visibilityAlpha, symbolIcon.getTextureAtlas().getWidth(), symbolIcon.getTextureAtlas().getWidth(), symbolIcon.getTextureAtlas().getTextureId());
            matrixStack.method_22909();
        }
        if ((int)alpha > 0) {
            int tc = (int)alpha << 24 | 0xFFFFFF;
            String name = w.getName();
            int len = fontRenderer.method_1727(name);
            matrixStack.method_22904(0.0, (double)(renderBackground ? -38 : -11), 0.0);
            matrixStack.method_22905(3.0f, 3.0f, 1.0f);
            int bgLen = Math.max(len + 2, 10);
            MapRenderHelper.fillIntoExistingBuffer(matrixStack.method_23760().method_23761(), textBGConsumer, -bgLen / 2, -1, bgLen / 2, 9, red, green, blue, alpha / 255.0f);
            MapRenderHelper.fillIntoExistingBuffer(matrixStack.method_23760().method_23761(), textBGConsumer, -bgLen / 2, -1, bgLen / 2, 8, 0.0f, 0.0f, 0.0f, alpha / 255.0f * 200.0f / 255.0f);
            if ((int)alpha > 3) {
                matrixStack.method_22904(0.0, 0.0, 1.0);
                Misc.drawNormalText(matrixStack, name, (float)(-(len - 1)) / 2.0f, 0.0f, tc, false, renderTypeBuffers);
            }
        }
    }
}

